<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class DPII_Session extends CI_Session {
	/* Set httponly flag on session cookies if it is configured in config settings
	 */
	public function __construct($params = array()) {
		$this->CI =& get_instance();
		$this->cookie_httponly = (isset($params['cookie_httponly'])) ? $params['cookie_httponly'] : $this->CI->config->item('cookie_httponly');
		parent::__construct($params);
	}
   
   /*
    * Do not update an existing session on ajax calls
    *
    * @access    public
    * @return    void
    */
    public function sess_update()
    {
        if ( ! IS_AJAX)
        {
            parent::sess_update();
        }
    }
	
	/**
	 * Write the session cookie
	 * Set httponly flag on session cookies if it is configured in config settings
	 * @access	public
	 * @return	void
	 */
	function _set_cookie($cookie_data = NULL)
	{
		if (is_null($cookie_data))
		{
			$cookie_data = $this->userdata;
		}

		// Serialize the userdata for the cookie
		$cookie_data = $this->_serialize($cookie_data);

		if ($this->sess_encrypt_cookie == TRUE)
		{
			$cookie_data = $this->CI->encrypt->encode($cookie_data);
		}
		else
		{
			// if encryption is not used, we provide an md5 hash to prevent userside tampering
			$cookie_data = $cookie_data.md5($cookie_data.$this->encryption_key);
		}

		$expire = ($this->sess_expire_on_close === TRUE) ? 0 : $this->sess_expiration + time();

		// Set the cookie
		setcookie(
					$this->sess_cookie_name,
					$cookie_data,
					$expire,
					$this->cookie_path,
					$this->cookie_domain,
					$this->cookie_secure,
					$this->cookie_httponly
				);
	}

    function sess_destroy()
	{
		// Kill the session DB row
		if ($this->sess_use_database === TRUE && isset($this->userdata['session_id']))
		{
			$this->CI->db->where('session_id', $this->userdata['session_id']);
			$this->CI->db->delete($this->sess_table_name);
		}

		// Kill the cookie
		setcookie(
					$this->sess_cookie_name,
					addslashes(serialize(array())),
					($this->now - 31500000),
					$this->cookie_path,
					$this->cookie_domain,
					$this->cookie_secure,
					$this->cookie_httponly
				);

		// Kill session data
		$this->userdata = array();
	}

	//sets an error message in the flashdata	
	public function set_error_message($message){
		$this->set_flashdata('message',json_encode($message));
		$this->set_flashdata('message_class','error');
	}
	
	public function set_service_permission_error_message($service, $message){
		$this->session->set_flashdata('service_failure_due_to_permission',true);
		$this->session->set_flashdata('failed_service_name', json_encode($service));
		$this->session->set_flashdata('service_failure_due_to_permission_message',json_encode($message));       
	}
	
	public function set_success_message($message){
		$this->set_flashdata('message', json_encode($message));
		$this->set_flashdata('message_class','success');	
	}
} 